#!/usr/bin/perl -wT
# $Id: br-submit.cgi 50 2015-02-10 10:31:51Z sanders $
BEGIN { $ENV{PATH} = "/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin"; }
use strict;
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use DBI;
use JSON;
use Socket;
use Data::Dumper;
my $cgi = new CGI;


# Retrieve and parse JSON data
my $blob = "";
my $handle = $cgi->upload('hostinfo');
if (defined $handle) {
    while (<$handle>) { $blob .= $_; }   
} elsif ($cgi->param('hostinfo')) {
    my $blob = $cgi->param('hostinfo');
}


# Try and parse it
die "Data is not well formed\n" if $blob !~ m/^({.*})$/;
my $obj = from_json($1);
die "Data is not complete\n" if (
    (not exists $$obj{uuid}) or
    (not exists $$obj{Hostname}) or
    (not exists $$obj{DefaultIP4}) or
    (not exists $$obj{DefaultIP6}) or
    (not exists $$obj{UpdatesAvailable}) or
    (not exists $$obj{UpdatesSecurity}) or
    (not exists $$obj{BITReportRevision}) or
    (not exists $$obj{UpdatesNeedReboot}) or
    (not exists $$obj{Packages}{Installed})
);


# Some boxes do not have IPv6. Updating with an empty value is not allowed.
if (exists $$obj{DefaultIP6} and ($$obj{DefaultIP6} eq "")) { 
    $$obj{DefaultIP6} = $$obj{DefaultIP4};
    $$obj{DefaultIP6} =~ s#\.#:#g;
}


# Who are we talking to.
die "Environment is not correct\n" if not exists $ENV{REMOTE_ADDR};
my $srcip = $ENV{REMOTE_ADDR};
my $srcrdns = "no.rdns";
if ($srcip =~ m/^((?:\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})|(?:[0-9a-f\:]+))$/) {
    if ( ! -e "/usr/bin/dig" ) {
        $srcrdns = "dig.binary.not.found";
    } else {
        $srcrdns = `/usr/bin/dig +short -x $1`;
        $srcrdns =~ s/[\.\r\n]+$//;
        $srcrdns = "no.rdns" if $srcrdns eq "";
    }
}


# Fetch databaseconfig from outside the webroot
my $cnf = {};
readConfig("../bit-report/database.pl");
my $dbh = DBI->connect($$cnf{dsn}, $$cnf{dbu}, $$cnf{dbp}) or die "Can't connect: $!\n";


# Construct SQL queries
my $sql_insert = <<EOS;
INSERT INTO servers
    (insert_time, report_date,
     uuid,              sourceip,    sourcerdns,        hostname,
     defaultip4,        defaultip6,  updatesavailable,  updatessecurity,
     updatesneedreboot, jsonblob)
VALUES
    (TIMESTAMP(NOW()), DATE(NOW()),
     ?,                 ?,           ?,                 ?,
     ?,                 ?,           ?,                 ?,
     ?,                 ?)
ON DUPLICATE KEY UPDATE
    report_date = DATE(NOW()),
    sourceip        = ?, sourcerdns        = ?,
    hostname        = ?, defaultip4        = ?,
    defaultip6      = ?, updatesavailable  = ?,
    updatessecurity = ?, updatesneedreboot = ?,
    jsonblob        = ?;
EOS


my $sth = $dbh->prepare($sql_insert) or die "Can't prepare: $DBI::errstr ($!)\n";
$sth->execute(
    $$obj{uuid},              $srcip,             $srcrdns,                 $$obj{Hostname},
    $$obj{DefaultIP4},        $$obj{DefaultIP6},  $$obj{UpdatesAvailable},  $$obj{UpdatesSecurity},
    $$obj{UpdatesNeedReboot}, $blob,

    $srcip,                 $srcrdns,
    $$obj{Hostname},        $$obj{DefaultIP4},
    $$obj{DefaultIP6},      $$obj{UpdatesAvailable},
    $$obj{UpdatesSecurity}, $$obj{UpdatesNeedReboot},
    $blob
) or die "Can't execute: $DBI::errstr ($!)\n";
$sth->finish();
$dbh->disconnect();


print "Content-type: text/plain\n\n";
print "That went fine.\nThank you, $srcip [$srcrdns]\n";
exit 0;


################################################################################
################################################################################
################################################################################
################################################################################


sub readConfig {
    my ($file) = @_;
    my $tmp = "";
    if (open(FD, "<$file")) {
        local $/ = undef; $tmp = <FD>; close(FD);
    } else {
        die "Can't readConfig $file: $!\n";
    }
    $tmp =~ m/(\$VAR1 = {.*})/s;
    $cnf = eval 'my ' . $1;
}


__END__
DROP TABLE IF EXISTS `servers`;
CREATE TABLE `servers` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,

    `insert_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    `report_date` date NOT NULL DEFAULT '1980-04-20',

    `uuid` varchar(36) NOT NULL,
    `sourceip` varchar(39) NOT NULL,
    `sourcerdns` varchar(255) NOT NULL,

    `hostname` varchar(255) NOT NULL,
    `defaultip4` varchar(15) NOT NULL,
    `defaultip6` varchar(39) NOT NULL DEFAULT '::1',

    `updatesavailable` bigint(20) NOT NULL DEFAULT '0',
    `updatessecurity` bigint(20) NOT NULL DEFAULT '0',
    `updatesneedreboot` tinyint(1) NOT NULL DEFAULT '0',

    `jsonblob` longtext NOT NULL,

    PRIMARY KEY (`id`),
    UNIQUE KEY `host_uniq` (`uuid`,`report_date`),
    KEY `sourceip` (`sourceip`),
    KEY `sourcerdns` (`sourcerdns`),
    KEY `hostname` (`hostname`),
    KEY `defaultip4` (`defaultip4`),
    KEY `defaultip6` (`defaultip6`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `servers_dca_link`;
CREATE TABLE `servers_dca_link` (
    `uuid` varchar(36) NOT NULL,
    `dca_object_id` bigint(20) NOT NULL DEFAULT '0',
    PRIMARY KEY (`uuid`),
       UNIQUE KEY `uk_uuid` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP VIEW IF EXISTS nojson;
CREATE VIEW nojson AS
    SELECT id, insert_time, report_date, uuid, sourceip,
        sourcerdns, hostname, defaultip4, defaultip6,
        updatesavailable, updatessecurity, updatesneedreboot
    FROM servers;
