#!/bin/bash
# We need to install dependencies only for Docker
[[ ! -e /.dockerenv ]] && exit 0

set -xe

source /etc/os-release

env

if [ $ID == "ubuntu" ]; then
    apt update -yqq > /dev/null
    DEBIAN_FRONTEND=noninteractive apt install -yqq git build-essential debhelper dh-autoreconf exim4 > /dev/null
fi

if [ $VERSION == "8" ]; then
    sed -i 's/mirrorlist/#mirrorlist/g' /etc/yum.repos.d/CentOS-*
    sed -i 's|#baseurl=http://mirror.centos.org|baseurl=http://vault.centos.org|g' /etc/yum.repos.d/CentOS-*
fi

if [  $ID == "centos" ]; then
    yum -y upgrade
    yum -y install rpm-build
    yum -y install systemd
    yum -y install rpmdevtools
    yum -y install rpmlint
    yum -y install iptables
fi
