%global pkgname bit-firewall

Name:           %{pkgname}
Version:        20150317
Release:        2
Summary:        Default BIT firewall package for IPv4 and IPv6
License:	GPT2+

%if %{use_systemd}
Requires: systemd
%else
Requires:           initscripts >= 8.36
Requires(postun):   initscripts
Requires(post):     chkconfig
Requires(preun):    chkconfig
%endif
Requires: 	iptables

%description
This firewall sets up rules for IPv4  and IPv6 in /etc/bit-firewall/,
prepends specific sanity rules and BIT admin rules to that and runs
it on the host. It ensures basic safety for the server it's running
on.

%pre
rm -rf /etc/init.d/bit-firewall

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/usr/sbin/
mkdir -p %{buildroot}/etc/{bit-firewall,init.d,default,systemd}
mkdir -p %{buildroot}/etc/systemd/system
install -m 755 $RPM_SOURCE_DIR/usr/sbin/bit-firewall %{buildroot}/usr/sbin/bit-firewall
install -m 755 $RPM_SOURCE_DIR/etc/init.d/bit-firewall %{buildroot}/etc/init.d/bit-firewall
install -m 755 $RPM_SOURCE_DIR//etc/systemd/system/bit-firewall.service %{buildroot}/etc/systemd/system/bit-firewall.service
install -m 644 $RPM_SOURCE_DIR/etc/bit-firewall/rules %{buildroot}/etc/bit-firewall/rules
install -m 644 $RPM_SOURCE_DIR/etc/bit-firewall/rules6 %{buildroot}/etc/bit-firewall/rules6
install -m 644 $RPM_SOURCE_DIR/etc/default/bit-firewall %{buildroot}/etc/default/bit-firewall

%preun
%if %use_systemd
    /usr/bin/systemctl --no-reload disable %{pkgname}.service >/dev/null 2>&1
    /usr/bin/systemctl stop %{pkgname}.service >/dev/null 2>&1
%else
    /sbin/service %{pkgname} stop > /dev/null 2>&1
    /sbin/chkconfig --del %{pkgname}
%endif


%postun
%if %use_systemd
    /usr/bin/systemctl daemon-reload >/dev/null 2>&1 ||:
%else
%{insserv_cleanup}
%endif

%files
/usr/sbin/bit-firewall
/etc/init.d/bit-firewall
/etc/systemd/system/bit-firewall.service
%config(noreplace) /etc/bit-firewall/rules
%config(noreplace) /etc/bit-firewall/rules6
/etc/default/bit-firewall

%changelog
* Tue Mar 17 2015 Sander Smeenk <sander@bit.nl> 20150317
  * Typo bump.
  * Explicit protocol match for INVALID drop rules.
