#!/bin/sh

### BEGIN INIT INFO
# Provides:          bit-firewall
# Short-Description: BIT Firewall
# Description:       Loads iptables firewall rules from /etc/bit-firewall/
# Required-Start:    $local_fs $remote_fs
# Required-Stop:     $local_fs $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
### END INIT INFO

PATH=/bin:/usr/bin:/sbin:/usr/sbin
IPTABLES="iptables"
IP6TABLES="ip6tables"
NAME=bit-firewall

case "$1" in
    start)
        /usr/sbin/bit-firewall start
    ;;

    stop)
        /usr/sbin/bit-firewall stop
    ;;

    force-reload|restart)
        /usr/sbin/bit-firewall stop
        /usr/sbin/bit-firewall start
    ;;

    *)
        echo "Usage: /etc/init.d/$NAME {start|stop|restart|force-reload}"
        exit 1
    ;;
esac

exit 0
