#!/bin/bash

for version in $(ls build/); do
  if [ ! -z $CI_PROJECT_NAME ]; then
    if [[ "$version" == "RPM" ]]; then
      if [[ -d /mnt/obit/public/rpm/$CI_PROJECT_NAME ]]; then
        LATEST_NOARCH=$(ls build/$version/ | grep -i noarch)
        cp build/$version/* /mnt/obit/public/rpm/$CI_PROJECT_NAME/
        cd /mnt/obit/public/rpm/$CI_PROJECT_NAME
        unlink $CI_PROJECT_NAME-latest.rpm
        ln -s $LATEST_NOARCH $CI_PROJECT_NAME-latest.rpm
      fi
    else
      if [[ -d /mnt/obit/public/ubuntu/$version && -d /mnt/obit/public/ubuntu/$version/$CI_PROJECT_NAME ]]; then
        cp build/$version/* /mnt/obit/public/ubuntu/$version/$CI_PROJECT_NAME/
        update-obit ubuntu $version $CI_PROJECT_NAME
      else
        echo "Ubuntu $version not found or $CI_PROJECT_NAME does not have a $version dir."
      fi
    fi
  else
    echo "Couldnt determine project name. Not deploying."
    exit 1
  fi
done
