Name:           bit-cron
Version:        20251209
Release:        3
Summary:        BIT's CRON wrapper script
License:	      GPT2+

Requires:       (exim4 or sendmail or postfix or qmail)

%description
Cronjobs should be performed on a regular basis and people should be
notified of any anomalities via a suitable method. BIT runs cronjobs
on our own servers as well as our customers' servers.

The purpose of this package is to have an automated method of boxes
in the field to report status and problems. We do this using the
bitcron(1) program, provided by the package.

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/usr/bin/
mkdir -p %{buildroot}/etc/cronscripts
mkdir -p %{buildroot}/usr/share/bit-cron/cronscripts
install -m 755 $RPM_SOURCE_DIR/bit-cron %{buildroot}/usr/bin/bit-cron
install -m 644 $RPM_SOURCE_DIR/cronscripts/mysql-backup.cron %{buildroot}/usr/share/bit-cron/cronscripts/mysql-backup.cron
install -m 644 $RPM_SOURCE_DIR/cronscripts/pgsql-backup.cron %{buildroot}/usr/share/bit-cron/cronscripts/pgsql-backup.cron
install -m 644 $RPM_SOURCE_DIR/cronscripts/prune-dir.cron %{buildroot}/usr/share/bit-cron/cronscripts/prune-dir.cron
install -m 644 $RPM_SOURCE_DIR/cronscripts/tape-backup.cron %{buildroot}/usr/share/bit-cron/cronscripts/tape-backup.cron
install -m 644 $RPM_SOURCE_DIR/cronscripts/mydumper.cron %{buildroot}/usr/share/bit-cron/cronscripts/mydumper.cron
install -m 644 $RPM_SOURCE_DIR/cronscripts/xtrabackup.cron %{buildroot}/usr/share/bit-cron/cronscripts/xtrabackup.cron

%post
ln -s /usr/bin/bit-cron /usr/bin/bitcron
mkdir -p /etc/cronscripts
mkdir /var/log/bit-cron

%files
/usr/bin/bit-cron
/usr/share/bit-cron/cronscripts/mysql-backup.cron
/usr/share/bit-cron/cronscripts/pgsql-backup.cron
/usr/share/bit-cron/cronscripts/prune-dir.cron
/usr/share/bit-cron/cronscripts/tape-backup.cron
/usr/share/bit-cron/cronscripts/mydumper.cron
/usr/share/bit-cron/cronscripts/xtrabackup.cron

%postun
if [ -d /etc/bit-cron/ ]; then
    echo "Purging /etc/bit-cron directory"
    rm -rf -- /etc/bit-cron
fi
if [ -d /var/log/bit-cron/ ]; then
    echo "Purging /var/log/bit-cron directory"
    rm -rf -- /var/log/bit-cron
fi
rm -f /usr/bin/bit-cron
unlink /usr/bin/bitcron

%changelog
* Wed May 22 2024 BIT Support <support@bit.nl> 20240522
- In the future, the use of absolute paths will be mandatory; in this version, a warning will be issued when an absolute path is not used.
- From now on, retention in the SQL backup scripts will be based on date instead of the number of backups.

* Thu Apr 11 2024 BIT Support <support@bit.nl> 20240411
- Improved backup scripts for mydumper and xtrabackup that allow backups and force rotation of the binary logs when enabled

* Thu Aug 15 2019 BIT Support <support@bit.nl> 20190815
- Fix prune-dir.cron with -print0 / -0 args.

* Wed Jul 24 2019 BIT Support <support@bit.nl> 20190724
- Drop mandatory AUTHOR flag in cronscript definitions, will now be silently ignored by bit-cron.
- Ignore crond(1) defined MAITO environment to prevent mail noise.
- Add 'version' to X-mailer header for rspamd.
