%global pkgname bit-firewall-ng

Name:           %{pkgname}
Version:        20230505
Release:        1%{?dist}
Summary:        Default BIT firewall package for IPv4 and IPv6 firewalling
License:	    GPT2+
BuildArch:      noarch

Buildrequires:  systemd
Requires:       systemd
Conflicts:      bit-firewall

%description
This firewall sets up rules for IPv4 and IPv6 in /etc/bit-firewall/,
prepends specific sanity rules and BIT admin rules to that and runs
it on the host. It ensures basic safety for the server it's running
on.

%pre
rm -rf /etc/init.d/bit-firewall

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/usr/sbin/
mkdir -p %{buildroot}/etc/{bit-firewall,default,systemd}
mkdir -p %{buildroot}/%_unitdir
mkdir -p %{buildroot}/%_presetdir
install -m 755 $RPM_SOURCE_DIR/usr/sbin/bit-firewall %{buildroot}/usr/sbin/bit-firewall
install -m 755 $RPM_SOURCE_DIR/etc/systemd/system/bit-firewall.service %{buildroot}/%_unitdir/bit-firewall.service
install -m 644 $RPM_SOURCE_DIR/etc/default/bit-firewall %{buildroot}/etc/default/bit-firewall
install -m 755 $RPM_SOURCE_DIR/usr/sbin/bit-firewall-setup %{buildroot}/usr/sbin/bit-firewall-setup
install -m 644 $RPM_SOURCE_DIR/%_presetdir/10-bit-firewall.preset %{buildroot}/%_presetdir/10-bit-firewall.preset

%post
/usr/sbin/bit-firewall-setup
%systemd_post bit-firewall.service

%preun
%systemd_preun bit-firewall.service

%postun
%systemd_postun_with_restart bit-firewall.service

%files
/usr/sbin/bit-firewall
/usr/sbin/bit-firewall-setup
%_unitdir/bit-firewall.service
%_presetdir/10-bit-firewall.preset
/etc/default/bit-firewall

%changelog
* Sun Mar 12 2023 BIT Support <support@bit.nl> 20230312
  * Rewrite of bit-firewall Next Gen

* Tue Feb 22 2022 Juul Spies <support@bit.nl> 20220222
  * Drop sysvinit support

* Tue Feb 15 2022 Juul Spies <support@bit.nl> 20220215
  * BIT maint server is a trusted default

* Tue Mar 17 2015 Sander Smeenk <sander@bit.nl> 20150317
  * Typo bump.
  * Explicit protocol match for INVALID drop rules.
