#!/bin/bash
# We need to install dependencies only for Docker
[[ ! -e /.dockerenv ]] && exit 0

set -xe

source /etc/os-release

env

if [ $ID == "ubuntu" ]; then
  apt-get update -yqq >/dev/null
  DEBIAN_FRONTEND=noninteractive apt-get install -yqq git build-essential dh-autoreconf exim4 debhelper >/dev/null

elif [ $ID == "almalinux" ]; then

  yum -y upgrade
  yum -y install rpm-build
  yum -y install systemd
  yum -y install rpmdevtools
  yum -y install rpmlint
  yum -y install iptables

fi
