#!/bin/bash 
# $Id: init.d 24 2012-02-06 16:10:18Z sanders $

PATH=/bin:/usr/bin:/sbin:/usr/sbin
IPTABLES="iptables"
IP6TABLES="ip6tables"
NAME=bit-firewall

stop4()
{
    $IPTABLES -P INPUT ACCEPT
    $IPTABLES -P FORWARD ACCEPT
    $IPTABLES -P OUTPUT ACCEPT
    $IPTABLES -F
    $IPTABLES -X
    $IPTABLES -t nat -F
    $IPTABLES -t nat -X
    $IPTABLES -t mangle -F
    $IPTABLES -t mangle -X
}

stop6()
{
    $IP6TABLES -P INPUT ACCEPT
    $IP6TABLES -P FORWARD ACCEPT
    $IP6TABLES -P OUTPUT ACCEPT
    $IP6TABLES -F
    $IP6TABLES -X
    $IP6TABLES -t mangle -F
    $IP6TABLES -t mangle -X
}

start6()
{
    # Flush first
    stop6;

    # Apply default rules?
    case "${DEFAULTRULES}" in [Yy][Ee][Ss])
        # Default sanity
        $IP6TABLES -A INPUT -i lo -j ACCEPT
        $IP6TABLES -A INPUT -p icmpv6 -j ACCEPT
        $IP6TABLES -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT

        # Trustlist 
        for PREFIX in $V6TRUSTED; do
            $IP6TABLES -A INPUT -s $PREFIX -j ACCEPT
        done

        # Blocklist
        for PREFIX in $V6BLOCKED; do
            $IP6TABLES -A INPUT -s $PREFIX -j DROP
            $IP6TABLES -A OUTPUT -d $PREFIX -j DROP
        done
    esac

    if [ -r /etc/bit-firewall/rules6 ]; then
        . /etc/bit-firewall/rules6
    fi
}


start4()
{
    # Flush first
    stop4;

    # Apply default rules?
    case "${DEFAULTRULES}" in [Yy][Ee][Ss])
        # Default sanity
        $IPTABLES -A INPUT -i lo -j ACCEPT
        $IPTABLES -A INPUT -p icmp -j ACCEPT
        $IPTABLES -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT

        # RFC1918 is allowed SSH access at least:
        $IPTABLES -A INPUT -s 192.168.0.0/16 -p tcp --dport 22 -j ACCEPT
        $IPTABLES -A INPUT -s 172.16.0.0/12 -p tcp --dport 22 -j ACCEPT
        $IPTABLES -A INPUT -s 10.0.0.0/8 -p tcp --dport 22 -j ACCEPT

        # Trustlist
        for PREFIX in $V4TRUSTED; do
            $IPTABLES -A INPUT -s $PREFIX -j ACCEPT
        done

        # Blocklist
        for PREFIX in $V4BLOCKED; do
            $IPTABLES -A INPUT -s $PREFIX -j DROP
            $IPTABLES -A OUTPUT -d $PREFIX -j DROP
        done
    esac

    if [ -r /etc/bit-firewall/rules ]; then
        . /etc/bit-firewall/rules
    fi
}

# Source defaults, if any
if [ -r /etc/default/bit-firewall ]; then
    . /etc/default/bit-firewall
fi

# Should we run?
case "$RUN" in
    [Yy][Ee][Ss])
    ;;

    *)
        $IPTABLES -F; $IP6TABLES -F
        echo "bit-firewall is DISABLED in /etc/default/bit-firewall !"
        exit 255
    ;;
esac

case "$1" in
    start)
        echo -n "Starting the BIT firewall "
        start4
        echo -n "[v4]"
        start6
        echo -n "[v6]"
        echo ". Done"
    ;;

    stop)
        echo -n "Stopping the BIT firewall ."
        stop4
        echo -n "[v4]"
        stop6
        echo -n "[v6]"
        echo ". Done"
        echo -e "\e[1mWARNING: Currently, you have no firewall running. This *could* be hazardous.\e[m"
    ;;

    force-reload|restart)
        stop4; stop6;
        echo -n "."
        start4; start6;
        echo ". Done."
    ;;

    *)
        echo "Usage: /etc/init.d/$NAME {start|stop|restart|force-reload}"
        exit 1
    ;;
esac

exit 0
# vim: filetype=sh tabstop=4 background=dark
