#!/bin/bash 
# $Id: init.d 34 2013-10-02 14:28:11Z sanders $

PATH=/bin:/usr/bin:/sbin:/usr/sbin
IPTABLES="iptables"
IP6TABLES="ip6tables"
NAME=bit-firewall

runv4()
{
    case "$RUNV4" in
        [Yy][Ee][Ss]) return 1 ;;
        *) return 0 ;;
    esac
}
runv6()
{
    case "$RUNV6" in
        [Yy][Ee][Ss]) return 1 ;;
        *) return 0 ;;
    esac
}

stop4()
{
    runv4; [ "$?" -eq 1 ] || return
    $IPTABLES -P INPUT ACCEPT
    $IPTABLES -P FORWARD ACCEPT
    $IPTABLES -P OUTPUT ACCEPT
    $IPTABLES -F
    $IPTABLES -X
    $IPTABLES -t nat -F >/dev/null 2>&1
    $IPTABLES -t nat -X >/dev/null 2>&1
    $IPTABLES -t mangle -F >/dev/null 2>&1
    $IPTABLES -t mangle -X >/dev/null 2>&1
}

stop6()
{
    runv6; [ "$?" -eq 1 ] || return
    $IP6TABLES -P INPUT ACCEPT
    $IP6TABLES -P FORWARD ACCEPT
    $IP6TABLES -P OUTPUT ACCEPT
    $IP6TABLES -F
    $IP6TABLES -X
    $IP6TABLES -t mangle -F >/dev/null 2>&1
    $IP6TABLES -t mangle -X >/dev/null 2>&1
}

start6()
{
    runv6; [ "$?" -eq 1 ] || return
    stop6;

    # Apply default rules?
    case "${DEFAULTRULES}" in [Yy][Ee][Ss])
        # Default sanity
        $IP6TABLES -A INPUT -i lo -j ACCEPT
        $IP6TABLES -A INPUT -p icmpv6 -j ACCEPT

        $IP6TABLES -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            echo ""
            echo "[v6] This system's ip6tables does not support state inspection"
            echo "You should keep this in mind while building your rules."
            echo ""
        fi

        # Trustlist 
        for PREFIX in $V6TRUSTED; do
            $IP6TABLES -A INPUT -s $PREFIX -j ACCEPT
        done

        # Blocklist
        for PREFIX in $V6BLOCKED; do
            $IP6TABLES -A INPUT -s $PREFIX -j DROP
            $IP6TABLES -A OUTPUT -d $PREFIX -j DROP
        done
    esac

    if [ -r /etc/bit-firewall/rules6 ]; then
        . /etc/bit-firewall/rules6
    fi
}


start4()
{
    runv4; [ "$?" -eq 1 ] || return
    stop4;

    # Apply default rules?
    case "${DEFAULTRULES}" in [Yy][Ee][Ss])
        # Default sanity
        $IPTABLES -A INPUT -i lo -j ACCEPT
        $IPTABLES -A INPUT -p icmp -j ACCEPT
        $IPTABLES -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT

        # RFC1918 is allowed SSH access at least:
        $IPTABLES -A INPUT -s 192.168.0.0/16 -p tcp --dport 22 -j ACCEPT
        $IPTABLES -A INPUT -s 172.16.0.0/12 -p tcp --dport 22 -j ACCEPT
        $IPTABLES -A INPUT -s 10.0.0.0/8 -p tcp --dport 22 -j ACCEPT

        # Trustlist
        for PREFIX in $V4TRUSTED; do
            $IPTABLES -A INPUT -s $PREFIX -j ACCEPT
        done

        # Blocklist
        for PREFIX in $V4BLOCKED; do
            $IPTABLES -A INPUT -s $PREFIX -j DROP
            $IPTABLES -A OUTPUT -d $PREFIX -j DROP
        done
    esac

    if [ -r /etc/bit-firewall/rules ]; then
        . /etc/bit-firewall/rules
    fi
}


# ==============================================================================


# Source defaults, if any
if [ -r /etc/default/bit-firewall ]; then
    . /etc/default/bit-firewall
fi

# Should we run at all?
case "$RUN" in
    [Yy][Ee][Ss])
    ;;

    *)
        echo "bit-firewall is DISABLED in /etc/default/bit-firewall !"
        exit 255
    ;;
esac

case "$1" in
    start)
        echo -n "Starting the BIT firewall "
        start4
        echo -n "[v4]"
        start6
        echo -n "[v6]"
        echo ". Done"
    ;;

    stop)
        echo -n "Stopping the BIT firewall ."
        stop4
        echo -n "[v4]"
        stop6
        echo -n "[v6]"
        echo ". Done"
        echo -e "\e[1mWARNING: Currently, you have no firewall running. This *could* be hazardous.\e[m"
    ;;

    force-reload|restart)
        stop4; stop6;
        echo -n "."
        start4; start6;
        echo ". Done."
    ;;

    *)
        echo "Usage: /etc/init.d/$NAME {start|stop|restart|force-reload}"
        exit 1
    ;;
esac

exit 0
# vim: filetype=sh tabstop=4 background=dark
