
#ifndef _main_h
#define _main_h

#include "config.h"
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/utsname.h>


#define DEFAULT_USER	"nobody"
#define UMASK   S_IRWXG | S_IRWXO
#define MAXSYSLOG   1024
#define MAXLINESIZE 4*1024
#define MEMBUFFER   64*1024


#define LOG_OPEN        0
#define LOG_FLUSH       SIGALRM
#define LOG_REOPEN      SIGHUP
#define LOG_CLOSE       SIGTERM


struct output_buffer {
    char *file;
    int fd;
    char buffer[MEMBUFFER];
    size_t len;
    void *line;
};


void usage(const char *fn);
void log_action(int action);

#endif /* _main_h */
