#!/bin/bash

CONFIG_FILE="/etc/hostname"

function set_hostname() {
    NAME=$1

    [ -n "$NAME" ] || exit 0

    echo $NAME > $CONFIG_FILE

    hostname $NAME
}

function get_dns_name() {
    first_ip=$(hostname -I | cut -d' ' -f1)
    text=$(host $first_ip)
    [ $? = 0 ] || exit 0
    [[ $text == *"has no PTR record" ]] && exit 0
    name=$(echo "$text" | awk '{print $(NF)}' | sed 's/\.$//')
    echo $name
}

if [ -n "$SET_HOSTNAME" ]; then
    set_hostname $SET_HOSTNAME
elif [ -n "$DNS_HOSTNAME" ]; then
    set_hostname $(get_dns_name)
fi
