dnl $Id: config.m4 321796 2012-01-05 17:23:48Z laruence $
PHP_ARG_WITH(lua, for lua support,
[  --with-lua=[DIR]    Include php lua support])

if test "$PHP_LUA" != "no"; then
	AC_MSG_CHECKING([for lua.h])

	for i in "$PHP_LUA" /usr /usr/include; do
		if test -r $i/lua.h; then
			LUA_DIR=$i
			PHP_ADD_INCLUDE($i)
		fi
		if test -r $i/include/lua/lua.h; then
			LUA_DIR=$i
			PHP_ADD_INCLUDE($i/include/lua)
		fi
		if test -r $i/lua/include/lua.h; then
			LUA_DIR=$i
			PHP_ADD_INCLUDE($i/lua/include)
		fi
		for v in 5.2 5.1 5.0; do
			if test -r $i/include/lua$v/lua.h; then
				LUA_DIR=$i
                LUA_LIB_VER=$v
				PHP_ADD_INCLUDE($i/include/lua$v)
				break
			fi
		done
		if test "$LUA_DIR" != ""; then
			break
		fi
	done

	AC_MSG_CHECKING([for lua library])
  
	PHP_CHECK_LIBRARY(lua$LUA_LIB_VER, lua_newstate,
	  [
		PHP_ADD_LIBRARY_WITH_PATH(lua$LUA_LIB_VER, $LUA_LIB_DIR, LUA_SHARED_LIBADD)
	  ],[
		AC_MSG_ERROR([Please reinstall the lua distribution - cannot link lua])
	  ],[
		-Llua$LUA_LIB_VER $LUA_SHARED_LIBADD
	  ])

	PHP_SUBST(LUA_SHARED_LIBADD)
	PHP_NEW_EXTENSION(lua, lua.c lua_closure.c, $ext_shared)
fi