/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.decoder;

import com.tigervnc.decoder.RawDecoder;
import com.tigervnc.decoder.common.Repaintable;
import com.tigervnc.vncviewer.RfbInputStream;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class TightDecoder
extends RawDecoder
implements ImageObserver {
    static final int EncodingTight = 7;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    static final int tightZlibBufferSize = 512;
    private Inflater[] tightInflaters = new Inflater[4];
    private Rectangle jpegRect;
    private Repaintable repainatableControl = null;
    private long statNumRectsTightJPEG = 0L;
    private long statNumRectsTight = 0L;

    public TightDecoder(Graphics graphics, RfbInputStream rfbInputStream) {
        super(graphics, rfbInputStream);
    }

    public TightDecoder(Graphics graphics, RfbInputStream rfbInputStream, int n, int n2) {
        super(graphics, rfbInputStream, n, n2);
    }

    public void setRepainableControl(Repaintable repaintable) {
        this.repainatableControl = repaintable;
    }

    public long getNumJPEGRects() {
        return this.statNumRectsTightJPEG;
    }

    public void setNumJPEGRects(int n) {
        this.statNumRectsTightJPEG = n;
    }

    public long getNumTightRects() {
        return this.statNumRectsTight;
    }

    public void setNumTightRects(int n) {
        this.statNumRectsTight = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRect(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        byte[] byArray;
        int n6;
        int n7;
        if (this.dos != null) {
            this.dos.writeInt(7);
        }
        int n8 = this.rfbis.readU8();
        if (this.dos != null) {
            this.dos.writeByte(n8 | 0xF);
        }
        for (n7 = 0; n7 < 4; ++n7) {
            if ((n8 & 1) != 0 && this.tightInflaters[n7] != null) {
                this.tightInflaters[n7] = null;
            }
            n8 >>= 1;
        }
        if (n8 > 9) {
            throw new Exception("Incorrect tight subencoding: " + n8);
        }
        if (n8 == 8) {
            if (this.bytesPerPixel == 1) {
                n7 = this.rfbis.readU8();
                this.graphics.setColor(this.getColor256()[n7]);
                if (this.dos != null) {
                    this.dos.writeByte(n7);
                }
            } else {
                byte[] byArray2 = new byte[3];
                this.rfbis.readFully(byArray2);
                if (this.dos != null) {
                    this.dos.write(byArray2);
                }
                Color color = new Color(0xFF000000 | (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF);
                this.graphics.setColor(color);
            }
            this.graphics.fillRect(n, n2, n3, n4);
            this.repainatableControl.scheduleRepaint(n, n2, n3, n4);
            return;
        }
        if (n8 == 9) {
            ++this.statNumRectsTightJPEG;
            byte[] byArray3 = new byte[this.rfbis.readCompactLen()];
            this.rfbis.readFully(byArray3);
            if (this.dos != null) {
                this.recordCompactLen(byArray3.length);
                this.dos.write(byArray3);
            }
            Image image = Toolkit.getDefaultToolkit().createImage(byArray3);
            Rectangle rectangle = this.jpegRect = new Rectangle(n, n2, n3, n4);
            synchronized (rectangle) {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        ++this.statNumRectsTight;
        n7 = 0;
        int n9 = n3;
        byte[] byArray4 = new byte[2];
        int[] nArray = new int[256];
        boolean bl = false;
        if ((n8 & 4) != 0) {
            n6 = this.rfbis.readU8();
            if (this.dos != null) {
                this.dos.writeByte(n6);
            }
            if (n6 == 1) {
                n7 = this.rfbis.readU8() + 1;
                if (this.dos != null) {
                    this.dos.writeByte(n7 - 1);
                }
                if (this.bytesPerPixel == 1) {
                    if (n7 != 2) {
                        throw new Exception("Incorrect tight palette size: " + n7);
                    }
                    this.rfbis.readFully(byArray4);
                    if (this.dos != null) {
                        this.dos.write(byArray4);
                    }
                } else {
                    byArray = new byte[n7 * 3];
                    this.rfbis.readFully(byArray);
                    if (this.dos != null) {
                        this.dos.write(byArray);
                    }
                    for (n5 = 0; n5 < n7; ++n5) {
                        nArray[n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                    }
                }
                if (n7 == 2) {
                    n9 = (n3 + 7) / 8;
                }
            } else if (n6 == 2) {
                bl = true;
            } else if (n6 != 0) {
                throw new Exception("Incorrect tight filter id: " + n6);
            }
        }
        if (n7 == 0 && this.bytesPerPixel == 4) {
            n9 *= 3;
        }
        if ((n6 = n4 * n9) < 12) {
            if (n7 != 0) {
                byArray = new byte[n6];
                this.rfbis.readFully(byArray);
                if (this.dos != null) {
                    this.dos.write(byArray);
                }
                if (n7 == 2) {
                    if (this.bytesPerPixel == 1) {
                        this.decodeMonoData(n, n2, n3, n4, byArray, byArray4);
                    } else {
                        this.decodeMonoData(n, n2, n3, n4, byArray, nArray);
                    }
                } else {
                    n5 = 0;
                    for (int i = n2; i < n2 + n4; ++i) {
                        for (int j = n; j < n + n3; ++j) {
                            TightDecoder.pixels24[i * this.framebufferWidth + j] = nArray[byArray[n5++] & 0xFF];
                        }
                    }
                }
            } else if (bl) {
                byArray = new byte[n3 * n4 * 3];
                this.rfbis.readFully(byArray);
                if (this.dos != null) {
                    this.dos.write(byArray);
                }
                this.decodeGradientData(n, n2, n3, n4, byArray);
            } else if (this.bytesPerPixel == 1) {
                for (int i = n2; i < n2 + n4; ++i) {
                    this.rfbis.readFully(pixels8, i * this.framebufferWidth + n, n3);
                    if (this.dos == null) continue;
                    this.dos.write(pixels8, i * this.framebufferWidth + n, n3);
                }
            } else {
                byArray = new byte[n3 * 3];
                for (int i = n2; i < n2 + n4; ++i) {
                    this.rfbis.readFully(byArray);
                    if (this.dos != null) {
                        this.dos.write(byArray);
                    }
                    int n10 = i * this.framebufferWidth + n;
                    for (n5 = 0; n5 < n3; ++n5) {
                        TightDecoder.pixels24[n10 + n5] = (byArray[n5 * 3] & 0xFF) << 16 | (byArray[n5 * 3 + 1] & 0xFF) << 8 | byArray[n5 * 3 + 2] & 0xFF;
                    }
                }
            }
        } else {
            int n11 = this.rfbis.readCompactLen();
            byte[] byArray5 = new byte[n11];
            this.rfbis.readFully(byArray5);
            int n12 = n8 & 3;
            if (this.tightInflaters[n12] == null) {
                this.tightInflaters[n12] = new Inflater();
            }
            Inflater inflater = this.tightInflaters[n12];
            inflater.setInput(byArray5);
            byte[] byArray6 = new byte[n6];
            inflater.inflate(byArray6);
            if (this.dos != null) {
                this.recordCompressedData(byArray6);
            }
            if (n7 != 0) {
                if (n7 == 2) {
                    if (this.bytesPerPixel == 1) {
                        this.decodeMonoData(n, n2, n3, n4, byArray6, byArray4);
                    } else {
                        this.decodeMonoData(n, n2, n3, n4, byArray6, nArray);
                    }
                } else {
                    int n13 = 0;
                    for (int i = n2; i < n2 + n4; ++i) {
                        for (int j = n; j < n + n3; ++j) {
                            TightDecoder.pixels24[i * this.framebufferWidth + j] = nArray[byArray6[n13++] & 0xFF];
                        }
                    }
                }
            } else if (bl) {
                this.decodeGradientData(n, n2, n3, n4, byArray6);
            } else if (this.bytesPerPixel == 1) {
                int n14 = n2 * this.framebufferWidth + n;
                for (int i = 0; i < n4; ++i) {
                    System.arraycopy(byArray6, i * n3, pixels8, n14, n3);
                    n14 += this.framebufferWidth;
                }
            } else {
                int n15 = 0;
                for (int i = 0; i < n4; ++i) {
                    inflater.inflate(byArray6);
                    int n16 = (n2 + i) * this.framebufferWidth + n;
                    for (int j = 0; j < n3; ++j) {
                        RawDecoder.pixels24[n16 + j] = (byArray6[n15] & 0xFF) << 16 | (byArray6[n15 + 1] & 0xFF) << 8 | byArray6[n15 + 2] & 0xFF;
                        n15 += 3;
                    }
                }
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
    }

    private void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = n2 * this.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n3 / 8; ++n8) {
                byte by = byArray[i * n6 + n8];
                for (n7 = 7; n7 >= 0; --n7) {
                    TightDecoder.pixels8[n5++] = byArray2[by >> n7 & 1];
                }
            }
            for (n7 = 7; n7 >= 8 - n3 % 8; --n7) {
                TightDecoder.pixels8[n5++] = byArray2[byArray[i * n6 + n8] >> n7 & 1];
            }
            n5 += this.framebufferWidth - n3;
        }
    }

    private void decodeMonoData(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) {
        int n5 = n2 * this.framebufferWidth + n;
        int n6 = (n3 + 7) / 8;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            for (n8 = 0; n8 < n3 / 8; ++n8) {
                byte by = byArray[i * n6 + n8];
                for (n7 = 7; n7 >= 0; --n7) {
                    TightDecoder.pixels24[n5++] = nArray[by >> n7 & 1];
                }
            }
            for (n7 = 7; n7 >= 8 - n3 % 8; --n7) {
                TightDecoder.pixels24[n5++] = nArray[byArray[i * n6 + n8] >> n7 & 1];
            }
            n5 += this.framebufferWidth - n3;
        }
    }

    private void decodeGradientData(int n, int n2, int n3, int n4, byte[] byArray) {
        byte[] byArray2 = new byte[n3 * 3];
        byte[] byArray3 = new byte[n3 * 3];
        byte[] byArray4 = new byte[3];
        int[] nArray = new int[3];
        int n5 = n2 * this.framebufferWidth + n;
        for (int i = 0; i < n4; ++i) {
            int n6;
            for (n6 = 0; n6 < 3; ++n6) {
                byArray4[n6] = (byte)(byArray2[n6] + byArray[i * n3 * 3 + n6]);
                byArray3[n6] = byArray4[n6];
            }
            TightDecoder.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            for (int j = 1; j < n3; ++j) {
                for (n6 = 0; n6 < 3; ++n6) {
                    nArray[n6] = (byArray2[j * 3 + n6] & 0xFF) + (byArray4[n6] & 0xFF) - (byArray2[(j - 1) * 3 + n6] & 0xFF);
                    if (nArray[n6] > 255) {
                        nArray[n6] = 255;
                    } else if (nArray[n6] < 0) {
                        nArray[n6] = 0;
                    }
                    byArray4[n6] = (byte)(nArray[n6] + byArray[(i * n3 + j) * 3 + n6]);
                    byArray3[j * 3 + n6] = byArray4[n6];
                }
                TightDecoder.pixels24[n5++] = (byArray4[0] & 0xFF) << 16 | (byArray4[1] & 0xFF) << 8 | byArray4[2] & 0xFF;
            }
            System.arraycopy(byArray3, 0, byArray2, 0, n3 * 3);
            n5 += this.framebufferWidth - n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xA0) == 0) {
            return true;
        }
        if ((n & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.graphics.drawImage(image, this.jpegRect.x, this.jpegRect.y, null);
                this.repainatableControl.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    void recordCompactLen(int n) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        byArray[n2++] = (byte)(n & 0x7F);
        if (n > 127) {
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] | 0x80);
            byArray[n2++] = (byte)(n >> 7 & 0x7F);
            if (n > 16383) {
                int n4 = n2 - 1;
                byArray[n4] = (byte)(byArray[n4] | 0x80);
                byArray[n2++] = (byte)(n >> 14 & 0xFF);
            }
        }
        if (this.dos != null) {
            this.dos.write(byArray, 0, n2);
        }
    }

    void recordCompressedData(byte[] byArray, int n, int n2) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray, n, n2);
        int n3 = n2 + n2 / 100 + 12;
        byte[] byArray2 = new byte[n3];
        deflater.finish();
        int n4 = deflater.deflate(byArray2);
        this.recordCompactLen(n4);
        if (this.dos != null) {
            this.dos.write(byArray2, 0, n4);
        }
    }

    void recordCompressedData(byte[] byArray) throws IOException {
        this.recordCompressedData(byArray, 0, byArray.length);
    }
}

