/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.vncviewer.RfbProto;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public abstract class TLSTunnelBase {
    Socket sock;

    public TLSTunnelBase(Socket socket) {
        this.sock = socket;
    }

    protected void initContext(SSLContext sSLContext) throws GeneralSecurityException {
        sSLContext.init(null, null, null);
    }

    public void setup(RfbProto rfbProto) throws Exception {
        if (rfbProto.readU8() == 0) {
            throw new Exception("Setup on the server failed");
        }
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            System.out.println("Generating TLS context");
            this.initContext(sSLContext);
            System.out.println("Doing TLS handshake");
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.sock, this.sock.getInetAddress().getHostName(), this.sock.getPort(), true);
            this.setParam(sSLSocket);
            sSLSocket.startHandshake();
            System.out.println("TLS done");
            rfbProto.setStreams(sSLSocket.getInputStream(), sSLSocket.getOutputStream());
        }
        catch (IOException iOException) {
            throw new Exception("TLS handshake failed " + iOException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new Exception("TLS handshake failed " + generalSecurityException.toString());
        }
    }

    protected abstract void setParam(SSLSocket var1);
}

