/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.vncviewer.MessageBox;
import com.tigervnc.vncviewer.TLSTunnelBase;
import java.io.StringBufferInputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509Tunnel
extends TLSTunnelBase {
    Certificate pvecert;

    public X509Tunnel(Socket socket, String string) throws CertificateException {
        super(socket);
        if (string != null) {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            this.pvecert = certificateFactory.generateCertificate(new StringBufferInputStream(string));
        }
    }

    @Override
    protected void setParam(SSLSocket sSLSocket) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = sSLSocket.getSupportedCipherSuites();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].matches(".*DH_anon.*")) continue;
            arrayList.add(stringArray[i]);
        }
        sSLSocket.setEnabledCipherSuites(arrayList.toArray(new String[0]));
    }

    @Override
    protected void initContext(SSLContext sSLContext) throws GeneralSecurityException {
        TrustManager[] trustManagerArray = this.pvecert != null ? new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                throw new CertificateException("no clients");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                boolean bl;
                if (x509CertificateArray == null || x509CertificateArray.length < 1) {
                    throw new CertificateException("no certs");
                }
                PublicKey publicKey = X509Tunnel.this.pvecert.getPublicKey();
                try {
                    x509CertificateArray[0].verify(publicKey);
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl && !X509Tunnel.this.pvecert.equals(x509CertificateArray[0])) {
                    throw new CertificateException("certificate does not match");
                }
            }
        }} : new TrustManager[]{new MyX509TrustManager()};
        sSLContext.init(null, trustManagerArray, null);
    }

    class MyX509TrustManager
    implements X509TrustManager {
        X509TrustManager tm;

        MyX509TrustManager() throws GeneralSecurityException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            trustManagerFactory.init(keyStore);
            this.tm = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.tm.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            block2: {
                try {
                    this.tm.checkServerTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException) {
                    MessageBox messageBox = new MessageBox(certificateException.toString(), 1);
                    if (messageBox.result()) break block2;
                    throw certificateException;
                }
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }
    }
}

